/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.transfer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import org.apache.commons.lang3.function.TriFunction;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;

public class EmptyFluidContainerTransfer
implements IFluidContainerTransfer {
    public static final class_2960 ID = Mantle.getResource("empty_item");
    private final class_1856 input;
    private final ItemOutput filled;
    protected final FluidStack fluid;
    public static final JsonDeserializer<EmptyFluidContainerTransfer> DESERIALIZER = new Deserializer<EmptyFluidContainerTransfer>(EmptyFluidContainerTransfer::new);

    @Override
    public void addRepresentativeItems(Consumer<class_1792> consumer) {
        for (class_1799 stack : this.input.method_8105()) {
            consumer.accept(stack.method_7909());
        }
    }

    @Override
    public boolean matches(class_1799 stack, FluidStack fluid) {
        return this.input.method_8093(stack);
    }

    protected FluidStack getFluid(class_1799 stack) {
        return this.fluid;
    }

    @Override
    public IFluidContainerTransfer.TransferResult transfer(class_1799 stack, FluidStack fluid, Storage<FluidVariant> handler) {
        FluidStack contained = this.getFluid(stack);
        long simulated = handler.simulateInsert((Object)contained.getType(), contained.getAmount(), null);
        if (simulated == this.fluid.getAmount()) {
            try (Transaction t = TransferUtil.getTransaction();){
                long actual = handler.insert((Object)contained.getType(), contained.getAmount(), (TransactionContext)t);
                if (actual > 0L) {
                    if (actual != this.fluid.getAmount()) {
                        Mantle.logger.error("Wrong amount filled from {}, expected {}, filled {}", (Object)class_7923.field_41178.method_10221((Object)stack.method_7909()), (Object)this.fluid.getAmount(), (Object)actual);
                    }
                    IFluidContainerTransfer.TransferResult transferResult = new IFluidContainerTransfer.TransferResult(this.filled.get().method_7972(), contained, false);
                    return transferResult;
                }
                t.commit();
            }
        }
        return null;
    }

    @Override
    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("type", ID.toString());
        json.add("input", this.input.method_8089());
        json.add("filled", this.filled.serialize());
        json.add("fluid", (JsonElement)RecipeHelper.serializeFluidStack(this.fluid));
        return json;
    }

    public EmptyFluidContainerTransfer(class_1856 input, ItemOutput filled, FluidStack fluid) {
        this.input = input;
        this.filled = filled;
        this.fluid = fluid;
    }

    public record Deserializer<T extends EmptyFluidContainerTransfer>(TriFunction<class_1856, ItemOutput, FluidStack, T> factory) implements JsonDeserializer<T>
    {
        public T deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = element.getAsJsonObject();
            class_1856 input = class_1856.method_52177((JsonElement)JsonHelper.getElement(json, "input"));
            ItemOutput filled = ItemOutput.fromJson(JsonHelper.getElement(json, "filled"));
            FluidStack fluid = RecipeHelper.deserializeFluidStack(class_3518.method_15296((JsonObject)json, (String)"fluid"));
            return (T)((EmptyFluidContainerTransfer)this.factory.apply((Object)input, (Object)filled, (Object)fluid));
        }
    }
}

